 ; Ŀ
 ;   Spor - spiral copier.                                                 
 ;   Copyright 1997, 1998, 2007 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Smack - make an ss of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns an ss.                 
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMACK (aaa / ss bbb)
  (setq ss (ssadd (setq bbb (entnext aaa)))) ; put next ent in new ss
 ; Ŀ
 ;   If the entity is an insert and there are attributes:                  
 ; 
  (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
           (= (cdr (assoc 66 (entget bbb))) 1))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (entnext bbb)                  ; while there are entities
         (setq bbb (entnext bbb))       ; find the next new entity
         (ssadd bbb ss)                 ; add it to the selection set
         (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                  (= (cdr (assoc 66 (entget bbb))) 1))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
  ss)
 ; Ŀ
 ;   Smack end.                                                            
 ; 

 ; Ŀ
 ;   Spor.                                                                 
 ; 
 (DEFUN C:SPOR (/ ss pa pbase angg ang1 dista coppes degp expanp angin pb ssl
                                                                          aaa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Save the last entity name so can find and rotate new entities later.  
 ; 
  (setq aaa (entlast))                 ; save the last entity
  (while (setq bbb (entnext aaa))
         (setq aaa bbb))
 ; Ŀ
 ;   Get an ss to spiral copy.                                             
 ; 
  (write-line "Stuff to spiral copy: ")
  (setq ss (ssget))
  (setq pa (getpoint "Centre: "))
  (setq pbase (getpoint pa "Entity base point: "))
  (setq ang1 (setq angg (angle pa pbase)))
  (setq dista (distance pa pbase))
 ; Ŀ
 ;   Number of copies.                                                     
 ; 
  (if (/= (type copes) 'INT) (setq copes 12))
  (setq coppes (getint (strcat "\nCopies <" (itoa copes) ">: ")))
  (if coppes (setq copes coppes))
 ; Ŀ
 ;   Rotation per copy.  Note that we ask for degrees but the Getangle     
 ;   function returns radians.  It assumes that manually typed numbers     
 ;   are degrees and converts them to radians.                             
 ; 
  (if (/= (type anginc) 'REAL) (setq anginc (/ pi 8)))
  (setq degp (getangle pa (strcat "\nDegrees rotation per copy <"
                                  (rtos (* anginc (/ 180 pi))) ">: ")))
  (if degp (setq anginc degp))
 ; Ŀ
 ;   Distance increment.                                                   
 ; 
  (if (/= (type expan) 'INT) (setq expan 16.0))
  (setq expanp (getdist pa (strcat "\nDistance increment <"
                                   (rtos expan) ">: ")))
  (if expanp (setq expan expanp))
 ; Ŀ
 ;   Do it.                                                                
 ; 
  (repeat copes
         (setq angg (+ angg anginc))
         (setq dista (+ dista expan))
         (setq pb (polar pa angg dista))
         (command ".copy" ss "" pbase pb)
 ; Ŀ
 ;   Find all new entities and make an ss of them.                         
 ; 
         (setq ssl (smack aaa))
         (setq aaa (entlast))                 ; save the new last entity
         (while (setq bbb (entnext aaa))
                (setq aaa bbb))
 ; Ŀ
 ;   Rotate them around the new base point by the difference between the   
 ;   original base to entity angle and the copy rotation angle.            
 ; 
         (command ".rotate" ssl "" pb (* (- angg ang1) (/ 180 pi))))
  (command "undo" "end")
 (princ))